class StatusFlash
{
  private:
    // Class Member Variables
    // These are initialized at startup
    unsigned int ledPin;           // the number of the LED pin
    unsigned int numFlashes;       // Number of flashes in the sequence
    unsigned long onTime;          // milliseconds of on-time
    unsigned long offTime;         // milliseconds of off-time
    unsigned long repeatTime;      // milliseconds until sequence repeats after final onTime
    // These maintain the current state
    unsigned int ledState;         // used to set the LED on/off
    unsigned int countFlashes;     // track progress through the sequence
    unsigned int onLevel;          // track sink/source (LOW/HIGH) for each LED
    unsigned long onStartTime;     // track start of LED turned on
    unsigned long offStartTime;    // track start of LED turned off
    unsigned long repeatStartTime; // track start of repeat time

  public:
    // Constructor - creates a StatusFlash and initializes the member variables and state
    StatusFlash(int pin, int flashes, long on, long off, long repeat, int onLvl);

    // Member functions
    void begin();
    void Update();


    /* Now, for every LED that we want to flash, we create an instance of the StatusFlash class
       by calling the constructor.  And on every pass through the loop we just need to call
       Update() for each instance of StatusFlash.

       NOTE that you can instantiate multiple instances on a single LED pin. That is how you can
       change the status of your system in your code. Just instantiate two or more StatusFlash
       objects on one LED pin, then when the system state changes, call Update() on whichever
       should be active.

       Usage:
       StatusFlash name(pin number, number of flashes, on time, off time, repeat time, LED on level)

       pin number         = the pin the LED is connected to.
       number of flashes  = the number of times the LED will flash.
       on time            = the duration the LED is on.
       off time           = the duration the LED is off between on states.
       repeat time        = after the LED has flashed the number of times, the duration until
                         the sequence starts again.
       LED on level       = either HIGH or LOW. What level for the LED to be on?

       Some examples:
       StatusFlash led01(LED_BUILTIN, 3, 100, 400, 2000, HIGH); // On-board LED
       StatusFlash led02(3, 5, 350, 350, 3100, LOW);            // D3 on UNO, XIAO
       StatusFlash led02(D3, 5, 350, 350, 3100, LOW);           // D3 on Wemos D1 Mini
       StatusFlash a1(A1, 2, 200, 200, 1000, LOW);              // A1
       StatusFlash ledon(LED_BUILTIN,1,1000,0,0,LOW);           // No flashing, just on.
       StatusFlash ledoff(LED_BUILTIN,1,0,1000,1000, LOW);      // No flashing, just off.

       Then, in setup(), call the begin() method to set the pinmode. ie:
        void setup() {
          led01.begin();
          led02.begin();
        }
    */

}; // End of StatusFlash class
