#include "statusflash.h"
#include "Arduino.h"

// Constructor
StatusFlash::StatusFlash(int pin, int flashes, long on, long off, long repeat, int onLvl)
{
  ledPin = pin;
  numFlashes = flashes;
  onTime = on;
  offTime = off;
  repeatTime = repeat;
  ledState, onLevel = onLvl; // Set this to the on level for your LED.
  countFlashes = 0;
  onStartTime, offStartTime, repeatStartTime = millis();
}

// Member functions
void StatusFlash::begin()
{
  // Set the pinmode in setup() to give the hardware a chance to settle on startup
  pinMode(ledPin, OUTPUT);
}

void StatusFlash::Update()
{
  // Check to see if it's time to change the state of the LED
  unsigned long currentMillis = millis();

  if (countFlashes < numFlashes) { // There are more flashes to come

    // Check which level (LOW/HIGH) turns the LED on due to different wiring configurations.

    if (onLevel == HIGH) { // Off = LOW, On = HIGH.
      if (!ledState) { // LED is off
        if (currentMillis - offStartTime >= offTime) { // It's time to turn the LED on
          ledState = !ledState;
          digitalWrite(ledPin, ledState);
          onStartTime = millis();
        }
      } else if (ledState) { // LED is on
        if (currentMillis - onStartTime >= onTime) { // It's time to turn the LED off
          ledState = !ledState;
          digitalWrite(ledPin, ledState);
          offStartTime = millis();
          countFlashes++;
          if (countFlashes == numFlashes) { // Final flash complete. Start repeatTime
            repeatStartTime = millis();
          }
        }
      }

    } else if (onLevel == LOW) { // Off = HIGH, On = LOW.
      if (ledState) { // LED is off
        if (currentMillis - offStartTime >= offTime) { // It's time to turn the LED on
          ledState = !ledState;
          digitalWrite(ledPin, ledState);
          onStartTime = millis();
        }
      } else if (!ledState) { // LED is on
        if (currentMillis - onStartTime >= onTime) { // It's time to turn the LED off
          ledState = !ledState;
          digitalWrite(ledPin, ledState);
          offStartTime = millis();
          countFlashes++;
          if (countFlashes == numFlashes) { // Final flash complete. Start repeatTime
            repeatStartTime = millis();
          }
        }
      }
    }

  } else { // No more flashes remain. We're in repeatTime
    if (currentMillis - repeatStartTime >= repeatTime) {
      countFlashes = 0;
      offStartTime = millis() - offTime;
    }
  }
}
