/*
   Matthew Small - d13@dthirteen.com - May 2021


   Demo:

   This sketch demonstrates the StatusFlash library.

   Required hardware:
   2 x LEDs, 1x button.

   2nd LED flashes however, forever, to demonstrate non-blocking.
   1st LED changes flash pattern to show status of the button. ie:

   if (button) { angryFlash } else if (!button) { happyFlash };

   Note that in this example I use a UNO R3 with which the LED_BUILTIN needs HIGH to turn
   on. And, being deliberately opposite for the example, the other LED needs LOW to turn on.
   The button is wired to provide a LOW when pressed.
*/

#include <statusflash.h>

/* UNO R3 */
StatusFlash happyFlash(LED_BUILTIN, 2, 100, 100, 4700, HIGH); // Button not pressed
StatusFlash angryFlash(LED_BUILTIN, 3, 600, 600, 1000, HIGH); // Button is pressed
StatusFlash otherLed(3, 5, 350, 350, 3100, LOW);   // This LED indictates some other thing

/* Configure the button */
const int buttonPin = 4;  // D4.
int buttonState = 0; // the pushbutton status

void setup()
{
  happyFlash.begin();
  angryFlash.begin();
  otherLed.begin();

  // initialize the pushbutton pin as an input:
  pinMode(buttonPin, INPUT_PULLUP);
}

void loop()
{
  // read the state of the pushbutton value:
  buttonState = digitalRead(buttonPin);

  // check if the pushbutton is pressed. If it is, the buttonState is LOW:
  if (buttonState == LOW) {
    angryFlash.Update();
  } else if (buttonState == HIGH) {
    happyFlash.Update();
  }

  // In the meantime, separate from the button state...
  otherLed.Update();
}
